<?php 

$ws_url = "https://connect.noritz.com/Thingworx/Things/nrz_thing_monitoring_detail/Services/getDataList";
$appKey = "cd71486a-9d76-4246-b012-73be8bf8e88e";

$today_in_milliseconds = time() * 1000;
$t24_hours_in_milliseconds = 30*24 * 60 * 60 * 1000; // days * hrs * mins * secs * milli
$milliseconds = $today_in_milliseconds - $t24_hours_in_milliseconds;

$data = array(
	'inYear'	=>	"2018",
 	'inThing'	=>	"AD00000123",
// 	'inThing'	=>	"AD00000032",
//	'inThing'	=>	"AD00000048", // Sample heater
	'inQuery'	=>	array(
		'filters'	=>	array(// 
			'fieldName'	=> 'recive_date',
			'type'		=> 'GE',
			'value'		=> $milliseconds,
		)
	)
);


$data_string = json_encode($data);                                                                                   
                                                                                                                     
$ch = curl_init($ws_url . "?appKey=" . $appKey);                                                                      
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");                                                                     
curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);                                                                  
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);                                                                        
curl_setopt($ch, CURLOPT_HTTPHEADER, array(                                                                       
    'Content-Type: application/json; charset=utf-8',
    'Accept: application/json',
    'Content-Length: ' . strlen($data_string),
    'Application Key: ' . $appKey
    )                                                                     
);                                                                                                                   
                                                                                                                     
$result = curl_exec($ch);

$result = str_replace("/Thingworx/", "https://connect.noritz.com/Thingworx/", $result);


include_once('../../inc/footer.php');


$obj = json_decode($result);

echo "<h4>Tabular Result</h4>";
$i=0;
$rows = array();
foreach($obj->rows as $row) {
	
	$rows[] = tr( date("d/m/Y H:i:s", $row->recive_date / 1000), $row->fuel_usage_total, $row->water_usage_total);
}

echo table($rows);
function tr($c,$d, $e) {
	$str = "";
	if (trim($d) != "") 
// 		$str = "<tr><td>" . trim($c) . "</td><td>" . trim($d) . "</td></tr>";
		$str = trim($c) . "\t" . trim($d) . "\t" . trim($e) . "\n";
	return $str;
}
function table($rows) {
	echo "<textarea style='height:500px;width:600px'>";
	foreach ($rows as $row) {
		echo $row;
	}
	echo "</textarea>";	
}